'# MWS Version: Version 2015.2 - Apr 03 2015 - ACIS 24.0.2 -

'# length = mm
'# frequency = GHz
'# time = ns
'# frequency range: fmin = 2.34 fmax = 2.54
'# created = '[VERSION]2014.3|23.0.0|20140703[/VERSION]


'@ use template: Antenna - Waveguide

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
'set the units
With Units
    .Geometry "mm"
    .Frequency "GHz"
    .Voltage "V"
    .Resistance "Ohm"
    .Inductance "NanoH"
    .TemperatureUnit  "Kelvin"
    .Time "ns"
    .Current "A"
    .Conductance "Siemens"
    .Capacitance "PikoF"
End With
'----------------------------------------------------------------------------
Plot.DrawBox True
With Background
     .Type "Normal"
     .Epsilon "1.0"
     .Mue "1.0"
     .XminSpace "0.0"
     .XmaxSpace "0.0"
     .YminSpace "0.0"
     .YmaxSpace "0.0"
     .ZminSpace "0.0"
     .ZmaxSpace "0.0"
End With
With Boundary
     .Xmin "expanded open"
     .Xmax "expanded open"
     .Ymin "expanded open"
     .Ymax "expanded open"
     .Zmin "expanded open"
     .Zmax "expanded open"
     .Xsymmetry "none"
     .Ysymmetry "none"
     .Zsymmetry "none"
End With
' switch on FD-TET setting for accurate farfields
FDSolver.ExtrudeOpenBC "True"
Mesh.FPBAAvoidNonRegUnite "True"
Mesh.ConsiderSpaceForLowerMeshLimit "False"
Mesh.MinimumStepNumber "5"
With MeshSettings
     .SetMeshType "Hex"
     .Set "RatioLimitGeometry", "20"
End With
With MeshSettings
     .SetMeshType "HexTLM"
     .Set "RatioLimitGeometry", "20"
End With
PostProcess1D.ActivateOperation "vswr", "true"
PostProcess1D.ActivateOperation "yz-matrices", "true"
'----------------------------------------------------------------------------
With MeshSettings
     .SetMeshType "Hex"
     .Set "Version", 1%
End With
With Mesh
     .MeshType "PBA"
End With
'set the solver type
ChangeSolverType("HF Time Domain")

'@ define curve analytical: curve1:analytical1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With AnalyticalCurve
     .Reset 
     .Name "analytical1" 
     .Curve "curve1" 
     .LawX "0" 
     .LawY "t" 
     .LawZ "t^2/4/F" 
     .ParameterRange "0", "H" 
     .Create
End With

'@ transform curve: rotate curve1:analytical1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "curve1:analytical1" 
     .Origin "Free" 
     .Center "0", "0", "0" 
     .Angle "ang", "0", "0" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Curve", "Rotate" 
End With

'@ transform curve: translate curve1:analytical1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "curve1:analytical1" 
     .Vector "0", "840", "0" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Curve", "Translate" 
End With

'@ define curve arc: curve1:arc1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Arc
     .Reset 
     .Name "arc1" 
     .Curve "curve1" 
     .Orientation "Clockwise" 
     .XCenter "-0" 
     .YCenter "-0" 
     .X1 "-0" 
     .Y1 "840" 
     .X2 "-840" 
     .Y2 "-0" 
     .Angle "70" 
     .UseAngle "True" 
     .Segments "0" 
     .Create
End With

'@ transform curve: rotate curve1:arc1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "curve1:arc1" 
     .Origin "Free" 
     .Center "0", "0", "0" 
     .Angle "0", "0", "35" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Curve", "Rotate" 
End With

'@ new component: component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Component.New "component1"

'@ define sweepprofile: component1:solid1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With SweepCurve
     .Reset 
     .Name "solid1" 
     .Component "component1" 
     .Material "PEC" 
     .Twistangle "0.0" 
     .Taperangle "0.0" 
     .ProjectProfileToPathAdvanced "False" 
     .Path "curve1:arc1" 
     .Curve "curve1:analytical1" 
     .Create
End With

'@ rename block: component1:solid1 to: component1:sphero_parabola

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Solid.Rename "component1:solid1", "sphero_parabola"

'@ transform: translate component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "component1" 
     .Vector "0", "-840", "0" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Translate" 
End With

'@ transform: rotate component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "component1" 
     .Origin "Free" 
     .Center "0", "0", "0" 
     .Angle "-ang", "0", "0" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Rotate" 
End With

'@ transform: translate component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "component1" 
     .Vector "0", "0", "-F" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Translate" 
End With

'@ transform: translate component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "component1" 
     .Vector "0", "hB", "0" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Translate" 
End With

'@ pick point

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Pick.PickPointFromCoordinates "0", "0", "0"

'@ transform: rotate component1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Transform 
     .Reset 
     .Name "component1" 
     .Origin "Free" 
     .Center "0", "0", "0" 
     .Angle "-angF", "0", "0" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Rotate" 
End With

'@ pick point

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Pick.PickPointFromCoordinates "0", "0", "0"

'@ define frequency range

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Solver.FrequencyRange "2.34", "2.54"

'@ define farfield monitor: farfield (f=2.442)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Reset 
     .Name "farfield (f=2.442)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "2.442" 
     .UseSubvolume "False" 
     .ExportFarfieldSource "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-222.54544128744",  "499.47501352353",  "-481.74506252457",  "40.016440368852" 
     .Create 
End With

'@ define farfield monitor: farfield (f=2.412)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Reset 
     .Name "farfield (f=2.412)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "2.412" 
     .UseSubvolume "False" 
     .ExportFarfieldSource "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-222.54544128744",  "499.47501352353",  "-481.74506252457",  "40.016440368852" 
     .Create 
End With

'@ define monitor: e-field (f=2.462)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Reset 
     .Name "e-field (f=2.462)" 
     .Dimension "Volume" 
     .Domain "Frequency" 
     .FieldType "Efield" 
     .Frequency "2.462" 
     .UseSubvolume "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-222.54544128744",  "499.47501352353",  "-481.74506252457",  "40.016440368852" 
     .Create 
End With

'@ define farfield monitor: farfield (f=2.462)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Delete "e-field (f=2.462)" 
End With 
With Monitor 
     .Reset 
     .Name "farfield (f=2.462)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "2.462" 
     .UseSubvolume "False" 
     .ExportFarfieldSource "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-222.54544128744",  "499.47501352353",  "-481.74506252457",  "40.016440368852" 
     .Create 
End With

'@ set mesh properties (Hexahedral)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Mesh 
     .MeshType "PBA" 
     .SetCreator "High Frequency"
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "Version", 1%
     'MAX CELL - WAVELENGTH REFINEMENT 
     .Set "StepsPerWaveNear", "10" 
     .Set "StepsPerWaveFar", "10" 
     .Set "WavelengthRefinementSameAsNear", "1" 
     'MAX CELL - GEOMETRY REFINEMENT 
     .Set "StepsPerBoxNear", "10" 
     .Set "StepsPerBoxFar", "1" 
     .Set "MaxStepNear", "0" 
     .Set "MaxStepFar", "0" 
     .Set "ModelBoxDescrNear", "maxedge" 
     .Set "ModelBoxDescrFar", "maxedge" 
     .Set "UseMaxStepAbsolute", "0" 
     .Set "GeometryRefinementSameAsNear", "0" 
     'MIN CELL 
     .Set "UseRatioLimitGeometry", "1" 
     .Set "RatioLimitGeometry", "20" 
     .Set "MinStepGeometryX", "0" 
     .Set "MinStepGeometryY", "0" 
     .Set "MinStepGeometryZ", "0" 
     .Set "UseSameMinStepGeometryXYZ", "1" 
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "FaceRefinementOn", "0" 
     .Set "FaceRefinementPolicy", "2" 
     .Set "FaceRefinementRatio", "2" 
     .Set "FaceRefinementStep", "0" 
     .Set "FaceRefinementNSteps", "2" 
     .Set "EllipseRefinementOn", "0" 
     .Set "EllipseRefinementPolicy", "2" 
     .Set "EllipseRefinementRatio", "2" 
     .Set "EllipseRefinementStep", "0" 
     .Set "EllipseRefinementNSteps", "2" 
     .Set "FaceRefinementBufferLines", "3" 
     .Set "EdgeRefinementOn", "1" 
     .Set "EdgeRefinementPolicy", "1" 
     .Set "EdgeRefinementRatio", "2" 
     .Set "EdgeRefinementStep", "0" 
     .Set "EdgeRefinementBufferLines", "3" 
     .Set "RefineEdgeMaterialGlobal", "0" 
     .Set "RefineAxialEdgeGlobal", "0" 
     .Set "BufferLinesNear", "3" 
     .Set "UseDielectrics", "1" 
     .Set "EquilibrateOn", "0" 
     .Set "Equilibrate", "1.5" 
     .Set "IgnoreThinPanelMaterial", "0" 
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "SnapToAxialEdges", "1"
     .Set "SnapToPlanes", "1"
     .Set "SnapToSpheres", "1"
     .Set "SnapToEllipses", "1"
     .Set "SnapToCylinders", "1"
     .Set "SnapToCylinderCenters", "1"
     .Set "SnapToEllipseCenters", "1"
End With 
With Discretizer 
     .MeshType "PBA" 
     .PBAType "Fast PBA" 
     .AutomaticPBAType "True" 
     .FPBAAccuracyEnhancement "enable"
     .ConnectivityCheck "False"
     .ConvertGeometryDataAfterMeshing "True" 
     .UsePecEdgeModel "True" 
     .GapDetection "False" 
     .FPBAGapTolerance "1e-3" 
     .SetMaxParallelMesherThreads "Hex", "12"
     .SetParallelMesherMode "Hex", "Maximum"
     .PointAccEnhancement "0" 
     .UseSplitComponents "True" 
     .EnableSubgridding "False" 
     .PBAFillLimit "99" 
     .AlwaysExcludePec "False" 
End With

'@ define special time domain solver parameters

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
'STEADY STATE
With Solver
     .SteadyStateDurationType "Number of pulses"
     .NumberOfPulseWidths "20"
     .SteadyStateDurationTime "83.2915"
     .SteadyStateDurationTimeAsDistance "2.498745e+004"
End With
'GENERAL
With Solver
     .TimeStepStabilityFactor "1.0"
     .RestartAfterInstabilityAbort "True"
     .AutomaticTimeSignalSampling "True"
     .ConsiderExcitationForFreqSamplingRate "False"
     .UseBroadBandPhaseShift "False"
     .SetBroadBandPhaseShiftLowerBoundFac "0.1"
     .SetPortShieldingType "NONE"
     .FrequencySamples "1001"
     .ConsiderTwoPortReciprocity "True"
     .EnergyBalanceLimit "0.03"
     .TDRComputation "False"
End With
'HEXAHEDRAL
With Solver
     .SetPMLType "CONVPML"
     .UseVariablePMLLayerSizeStandard "False"
     .KeepPMLDepthDuringMeshAdaptationWithVariablePMLLayerSize "False"
     .SetSubcycleState "Automatic"
     .NormalizeToReferenceSignal "False"
     .SimplifiedPBAMethod "False"
     .SParaAdjustment "True"
     .PrepareFarfields "True"
     .SetSubgridCycleState "Automatic"
End With
'MATERIAL
With Solver
     .SurfaceImpedanceOrder "10"
     .ActivatePowerLoss1DMonitor "True"
     .SetDispNonLinearMaterialMonitor "False"
End With
'AR-FILTER
With Solver
     .UseArfilter "False"
     .ArMaxEnergyDeviation "0.1"
     .ArPulseSkip "1"
End With
'WAVEGUIDE
With Solver
     .WaveguideBroadband "False"
     .SetBBPSamples "5"
     .DispEpsFullDeembedding "False"
     .SetSamplesFullDeembedding "20"
     .UseOpenBoundaryForHigherModes "True"
     .WaveguidePortROM "False"
     .WaveguidePortGeneralized "False"
     .SetModeFreqFactor "0.5"
     .AdaptivePortMeshing "True"
     .AccuracyAdaptivePortMeshing "1"
     .PassesAdaptivePortMeshing "4"
End With
'HEXAHEDRAL TLM
With Solver
     .UseDataId ""
     .UseMeshType "2"
     .UseAbsorbingBoundary "True"
     .UseDoublePrecision "False"
     .ShowResultsInTree "True"
     .AllowMaterialOverlap "True"
     .ExcitePlanewaveNearModel "False"
     .SetGroundPlane "False"
     .GroundPlane "x", "0.0"
     .NumberOfLayers "5"
     .HealCheckAllObjects "False"
End With
'TLM POSTPROCESSING
With Solver
     .ResetSettings
     .CalculateFullPatternForFarField "true", "Medium" 
     .CalculatePatternOnCuts "false" 
     .CalculatePatternOnConicalCuts "false" 
     .PhaseReferencePoint "0", "0", "0" 
     .CutsCoPolarAndCrossPolar "true" 
     .CutsThetaAndPhi "false" 
     .CutsAxialRatio "false" 
     .CutsDBs "true" 
     .CutsRelativeMagnitudeAndPhase "false" 
     .CutsAllPolarizations "false" 
     .CutsNormalization "dB-boresight" 
     .CutsResolution "1.0" 
     .CutsExtent "180" 
     .CutsSpacing "45" 
     .CutsPolarizationAndBoresightAxes "Auto", "Auto" 
     .ConicalThetaAndPhi "true" 
     .ConicalAxialRatio "false" 
     .ConicalAllPolarizations "false" 
     .ConicalDBs "true" 
     .ConicalRelativeMagnitudeAndPhase "false" 
     .ConicalNormalization "dB-isotrope" 
     .ConicalResolution "3.0" 
     .Cones "0", "180", "10" 
     .ConeAndFrontAxes "+y", "+z" 
     .CalculateNearFieldOnCylindricalSurfaces "false", "Coarse" 
     .CylinderGridCustomStep "1" 
     .CalculateNearFieldOnCircularCuts "false" 
     .CylinderBaseCenter "0", "0", "0" 
     .CylinderRadius "3" 
     .CylinderHeight "3" 
     .CylinderSpacing "1" 
     .CylinderResolution "2.0" 
     .CylinderAllPolarization "true" 
     .CylinderRadialAngularVerticalComponents "false" 
     .CylinderMagnitudeOfTangentialConponent "false" 
     .CylinderVm "true" 
     .CylinderDBVm "false" 
     .CylinderDBUVm "false" 
     .CylinderAndFrontAxes "+y", "+z" 
     .CalculateSMatrix "true" 
     .CalculateZMatrix "false" 
     .CalculateYMatrix "false" 
     .CalculateZInput "true" 
     .CalculateSWR "false" 
     .CalculateDB "true" 
     .WriteTouchstone "false" 
     .TwoPortDeviceIsLossless "false" 
     .TwoPortDeviceHasIdenticalPorts "false" 
     .TwoPortDeviceIsSymmetric "false" 
     .FrequencyMap "false" 
     .NormalizedSMatrix "false" 
     .NormalizingImpedance "50" 
     .CutoffFrequency "1" 
     .ApplyLinearPrediction "false" 
     .Windowing "None" 
     .InvertDBScale "false" 
     .CalculateMagnitudeAndPhase "true" 
     .AutoFreqStep "true", "1"
     .MultiplyConstantFactor "false", "1"
     .DivideBySignal "false", ""
     .CalculateDBRelativeTo "false", "Unit magnitude"
     .SetExcitationSignal "" 
     .SaveSettings
End With

'@ define time domain solver parameters

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Mesh.SetCreator "High Frequency" 
With Solver 
     .Method "Hexahedral"
     .CalculationType "TD-S"
     .StimulationPort "All"
     .StimulationMode "All"
     .SteadyStateLimit "-30.0"
     .MeshAdaption "False"
     .AutoNormImpedance "False"
     .NormingImpedance "50"
     .CalculateModesOnly "False"
     .SParaSymmetry "False"
     .StoreTDResultsInCache  "False"
     .FullDeembedding "False"
     .SuperimposePLWExcitation "False"
     .UseSensitivityAnalysis "False"
End With

'@ new component: component1/antena

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Component.New "component1/antena"

'@ define cylinder: component1/antena:solid1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid1" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "D1/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "0", "-1" 
     .Xcenter "0" 
     .Ycenter "0" 
     .Segments "0" 
     .Create 
End With

'@ define cylinder: component1/antena:solid2

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid2" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "D2/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "-h1-1", "-h1-2" 
     .Xcenter "0" 
     .Ycenter "0" 
     .Segments "0" 
     .Create 
End With

'@ define cylinder: component1/antena:solid3

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid3" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "D3/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "-h1-h2-2", "-h1-h2-3" 
     .Xcenter "0" 
     .Ycenter "0" 
     .Segments "0" 
     .Create 
End With

'@ define cylinder: component1/antena:solid4

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid4" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "D4/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "3", "-h3" 
     .Xcenter "0" 
     .Ycenter "0" 
     .Segments "0" 
     .Create 
End With

'@ define material: Teflon (PTFE) (loss free)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Material
     .Reset
     .Name "Teflon (PTFE) (loss free)"
     .Folder ""
.FrqType "all" 
.Type "Normal" 
.SetMaterialUnit "GHz", "mm"
.Epsilon "2.1" 
.Mue "1.0" 
.Kappa "0.0" 
.TanD "0.0" 
.TanDFreq "0.0" 
.TanDGiven "False" 
.TanDModel "ConstTanD" 
.KappaM "0.0" 
.TanDM "0.0" 
.TanDMFreq "0.0" 
.TanDMGiven "False" 
.TanDMModel "ConstKappa" 
.DispModelEps "None" 
.DispModelMue "None" 
.DispersiveFittingSchemeEps "General 1st" 
.DispersiveFittingSchemeMue "General 1st" 
.UseGeneralDispersionEps "False" 
.UseGeneralDispersionMue "False" 
.Rho "2200.0" 
.ThermalType "Normal" 
.ThermalConductivity "0.2"
.HeatCapacity "1.0"
.SetActiveMaterial "all" 
.MechanicsType "Isotropic"
.YoungsModulus "0.5"
.PoissonsRatio "0.4"
.ThermalExpansionRate "140"
.Colour "0.75", "0.95", "0.85" 
.Wireframe "False" 
.Transparency "0" 
.Create
End With

'@ define cylinder: component1/antena:solid5

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid5" 
     .Component "component1/antena" 
     .Material "Teflon (PTFE) (loss free)" 
     .OuterRadius "4.1/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "9.3", "-3" 
     .Xcenter "0" 
     .Ycenter "-c" 
     .Segments "0" 
     .Create 
End With

'@ boolean insert shapes: component1/antena:solid1, component1/antena:solid5

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Solid 
     .Version 9
     .Insert "component1/antena:solid1", "component1/antena:solid5" 
     .Version 1
End With

'@ define cylinder: component1/antena:solid6

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid6" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "5.3/2" 
     .InnerRadius "4.1/2" 
     .Axis "z" 
     .Zrange "0", "9.3" 
     .Xcenter "0" 
     .Ycenter "-c" 
     .Segments "0" 
     .Create 
End With

'@ new component: component1/antena/radom

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Component.New "component1/antena/radom"

'@ define cylinder: component1/antena:solid9

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Cylinder 
     .Reset 
     .Name "solid9" 
     .Component "component1/antena" 
     .Material "PEC" 
     .OuterRadius "1.23/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "9.3", "-h1-2.2" 
     .Xcenter "0" 
     .Ycenter "-c" 
     .Segments "0" 
     .Create 
End With

'@ define autointersection settings

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Solid
     .SetAutoIntersectionCheckElMag "True" 
     .SetAutoIntersectionCheckThermal "False" 
     .SetAutoIntersectionCheckMechanics "False" 
End With

'@ boolean insert shapes: component1/antena:solid5, component1/antena:solid9

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Solid 
     .Version 9
     .Insert "component1/antena:solid5", "component1/antena:solid9" 
     .Version 1
End With

'@ pick face

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Pick.PickFaceFromId "component1/antena:solid6", "3"

'@ define port: 1

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Port 
     .Reset 
     .PortNumber "1" 
     .Label "" 
     .NumberOfModes "1" 
     .AdjustPolarization "False" 
     .PolarizationAngle "0.0" 
     .ReferencePlaneDistance "0" 
     .TextSize "50" 
     .Coordinates "Picks" 
     .Orientation "positive" 
     .PortOnBound "False" 
     .ClipPickedPortToBound "False" 
     .Xrange "-2.65", "2.65" 
     .Yrange "-26.95", "-21.65" 
     .Zrange "9.3", "9.3" 
     .XrangeAdd "0.0", "0.0" 
     .YrangeAdd "0.0", "0.0" 
     .ZrangeAdd "0.0", "0.0" 
     .SingleEnded "False" 
     .Create 
End With

'@ switch working plane

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawWorkplane "false"

'@ switch bounding box

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawBox "False"

'@ switch working plane

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawWorkplane "true"

'@ switch bounding box

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawBox "True"

'@ switch working plane

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawWorkplane "false"

'@ switch bounding box

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawBox "False"

'@ define special time domain solver parameters

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
'STEADY STATE
With Solver
     .SteadyStateDurationType "Number of pulses"
     .NumberOfPulseWidths "20"
     .SteadyStateDurationTime "83.2915"
     .SteadyStateDurationTimeAsDistance "2.498745e+004"
End With
'GENERAL
With Solver
     .TimeStepStabilityFactor "1.0"
     .RestartAfterInstabilityAbort "True"
     .AutomaticTimeSignalSampling "True"
     .ConsiderExcitationForFreqSamplingRate "False"
     .UseBroadBandPhaseShift "False"
     .SetBroadBandPhaseShiftLowerBoundFac "0.1"
     .SetPortShieldingType "NONE"
     .FrequencySamples "1001"
     .ConsiderTwoPortReciprocity "True"
     .EnergyBalanceLimit "0.03"
     .TDRComputation "False"
End With
'HEXAHEDRAL
With Solver
     .SetPMLType "CONVPML"
     .UseVariablePMLLayerSizeStandard "False"
     .KeepPMLDepthDuringMeshAdaptationWithVariablePMLLayerSize "False"
     .SetSubcycleState "Automatic"
     .NormalizeToReferenceSignal "False"
     .SimplifiedPBAMethod "False"
     .SParaAdjustment "True"
     .PrepareFarfields "True"
     .SetSubgridCycleState "Automatic"
End With
'MATERIAL
With Solver
     .SurfaceImpedanceOrder "10"
     .ActivatePowerLoss1DMonitor "True"
     .SetDispNonLinearMaterialMonitor "False"
End With
'AR-FILTER
With Solver
     .UseArfilter "False"
     .ArMaxEnergyDeviation "0.1"
     .ArPulseSkip "1"
End With
'WAVEGUIDE
With Solver
     .WaveguideBroadband "False"
     .SetBBPSamples "5"
     .DispEpsFullDeembedding "False"
     .SetSamplesFullDeembedding "20"
     .UseOpenBoundaryForHigherModes "True"
     .WaveguidePortROM "False"
     .WaveguidePortGeneralized "False"
     .SetModeFreqFactor "0.5"
     .AdaptivePortMeshing "True"
     .AccuracyAdaptivePortMeshing "1"
     .PassesAdaptivePortMeshing "4"
End With
'HEXAHEDRAL TLM
With Solver
     .UseDataId ""
     .UseMeshType "2"
     .UseAbsorbingBoundary "True"
     .UseDoublePrecision "False"
     .ShowResultsInTree "True"
     .AllowMaterialOverlap "True"
     .ExcitePlanewaveNearModel "False"
     .SetGroundPlane "False"
     .GroundPlane "x", "0.0"
     .NumberOfLayers "5"
     .HealCheckAllObjects "False"
End With
'TLM POSTPROCESSING
With Solver
     .ResetSettings
     .CalculateFullPatternForFarField "true", "Medium" 
     .CalculatePatternOnCuts "false" 
     .CalculatePatternOnConicalCuts "false" 
     .PhaseReferencePoint "0", "0", "0" 
     .CutsCoPolarAndCrossPolar "true" 
     .CutsThetaAndPhi "false" 
     .CutsAxialRatio "false" 
     .CutsDBs "true" 
     .CutsRelativeMagnitudeAndPhase "false" 
     .CutsAllPolarizations "false" 
     .CutsNormalization "dB-boresight" 
     .CutsResolution "1.0" 
     .CutsExtent "180" 
     .CutsSpacing "45" 
     .CutsPolarizationAndBoresightAxes "Auto", "Auto" 
     .ConicalThetaAndPhi "true" 
     .ConicalAxialRatio "false" 
     .ConicalAllPolarizations "false" 
     .ConicalDBs "true" 
     .ConicalRelativeMagnitudeAndPhase "false" 
     .ConicalNormalization "dB-isotrope" 
     .ConicalResolution "3.0" 
     .Cones "0", "180", "10" 
     .ConeAndFrontAxes "+y", "+z" 
     .CalculateNearFieldOnCylindricalSurfaces "false", "Coarse" 
     .CylinderGridCustomStep "1" 
     .CalculateNearFieldOnCircularCuts "false" 
     .CylinderBaseCenter "0", "0", "0" 
     .CylinderRadius "3" 
     .CylinderHeight "3" 
     .CylinderSpacing "1" 
     .CylinderResolution "2.0" 
     .CylinderAllPolarization "true" 
     .CylinderRadialAngularVerticalComponents "false" 
     .CylinderMagnitudeOfTangentialConponent "false" 
     .CylinderVm "true" 
     .CylinderDBVm "false" 
     .CylinderDBUVm "false" 
     .CylinderAndFrontAxes "+y", "+z" 
     .CalculateSMatrix "true" 
     .CalculateZMatrix "false" 
     .CalculateYMatrix "false" 
     .CalculateZInput "true" 
     .CalculateSWR "false" 
     .CalculateDB "true" 
     .WriteTouchstone "false" 
     .TwoPortDeviceIsLossless "false" 
     .TwoPortDeviceHasIdenticalPorts "false" 
     .TwoPortDeviceIsSymmetric "false" 
     .FrequencyMap "false" 
     .NormalizedSMatrix "false" 
     .NormalizingImpedance "50" 
     .CutoffFrequency "1" 
     .ApplyLinearPrediction "false" 
     .Windowing "None" 
     .InvertDBScale "false" 
     .CalculateMagnitudeAndPhase "true" 
     .AutoFreqStep "true", "1"
     .MultiplyConstantFactor "false", "1"
     .DivideBySignal "false", ""
     .CalculateDBRelativeTo "false", "Unit magnitude"
     .SetExcitationSignal "" 
     .SaveSettings
End With

'@ define time domain solver parameters

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Mesh.SetCreator "High Frequency" 
With Solver 
     .Method "Hexahedral"
     .CalculationType "TD-S"
     .StimulationPort "All"
     .StimulationMode "All"
     .SteadyStateLimit "-40.0"
     .MeshAdaption "False"
     .AutoNormImpedance "False"
     .NormingImpedance "50"
     .CalculateModesOnly "False"
     .SParaSymmetry "False"
     .StoreTDResultsInCache  "False"
     .FullDeembedding "False"
     .SuperimposePLWExcitation "False"
     .UseSensitivityAnalysis "False"
End With

'@ switch bounding box

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawBox "True"

'@ farfield plot options

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With FarfieldPlot 
     .Plottype "3D" 
     .Vary "angle1" 
     .Theta "90" 
     .Phi "90" 
     .Step "5" 
     .Step2 "5" 
     .SetLockSteps "True" 
     .SetPlotRangeOnly "False" 
     .SetThetaStart "0" 
     .SetThetaEnd "180" 
     .SetPhiStart "0" 
     .SetPhiEnd "360" 
     .SetTheta360 "False" 
     .SymmetricRange "False" 
     .SetTimeDomainFF "False" 
     .SetFrequency "2.442" 
     .SetTime "0" 
     .SetColorByValue "True" 
     .DrawStepLines "False" 
     .DrawIsoLongitudeLatitudeLines "False" 
     .ShowStructure "True" 
     .SetStructureTransparent "False" 
     .SetFarfieldTransparent "True" 
     .SetSpecials "enablepolarextralines" 
     .SetPlotMode "Directivity" 
     .Distance "1" 
     .UseFarfieldApproximation "True" 
     .SetScaleLinear "False" 
     .SetLogRange "30" 
     .SetLogNorm "0" 
     .DBUnit "0" 
     .EnableFixPlotMaximum "False" 
     .SetFixPlotMaximumValue "1" 
     .SetInverseAxialRatio "False" 
     .SetAxesType "user" 
     .SetAntennaType "unknown" 
     .Phistart "1.000000e+000", "0.000000e+000", "0.000000e+000" 
     .Thetastart "0.000000e+000", "0.000000e+000", "1.000000e+000" 
     .PolarizationVector "0.000000e+000", "1.000000e+000", "0.000000e+000" 
     .SetCoordinateSystemType "spherical" 
     .SetAutomaticCoordinateSystem "True" 
     .SetPolarizationType "Linear" 
     .SlantAngle 0.000000e+000 
     .Origin "bbox" 
     .Userorigin "0.000000e+000", "0.000000e+000", "0.000000e+000" 
     .SetUserDecouplingPlane "False" 
     .UseDecouplingPlane "False" 
     .DecouplingPlaneAxis "X" 
     .DecouplingPlanePosition "0.000000e+000" 
     .LossyGround "False" 
     .GroundEpsilon "1" 
     .GroundKappa "0" 
     .EnablePhaseCenterCalculation "False" 
     .SetPhaseCenterAngularLimit "3.000000e+001" 
     .SetPhaseCenterComponent "boresight" 
     .SetPhaseCenterPlane "both" 
     .ShowPhaseCenter "True" 
     .StoreSettings
End With

'@ define monitor: e-field (f=2.340)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Reset 
     .Name "e-field (f=2.340)" 
     .Dimension "Volume" 
     .Domain "Frequency" 
     .FieldType "Efield" 
     .Frequency "2.340" 
     .UseSubvolume "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-220.84934509513",  "501.17110971584",  "-482.80490105304",  "40.016440368852" 
     .Create 
End With

'@ define farfield monitor: farfield (f=2.340)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Delete "e-field (f=2.340)" 
End With 
With Monitor 
     .Reset 
     .Name "farfield (f=2.340)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "2.340" 
     .UseSubvolume "False" 
     .ExportFarfieldSource "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-220.84934509513",  "501.17110971584",  "-482.80490105304",  "40.016440368852" 
     .Create 
End With

'@ define farfield monitor: farfield (f=2.500)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Monitor 
     .Reset 
     .Name "farfield (f=2.500)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "2.500" 
     .UseSubvolume "False" 
     .ExportFarfieldSource "False" 
     .SetSubvolume  "-624.68613656555",  "624.68613656555",  "-220.84934509513",  "501.17110971584",  "-482.80490105304",  "40.016440368852" 
     .Create 
End With

'@ farfield plot options

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With FarfieldPlot 
     .Plottype "3D" 
     .Vary "angle1" 
     .Theta "90" 
     .Phi "90" 
     .Step "5" 
     .Step2 "5" 
     .SetLockSteps "True" 
     .SetPlotRangeOnly "False" 
     .SetThetaStart "0" 
     .SetThetaEnd "180" 
     .SetPhiStart "0" 
     .SetPhiEnd "360" 
     .SetTheta360 "False" 
     .SymmetricRange "False" 
     .SetTimeDomainFF "False" 
     .SetFrequency "2.5" 
     .SetTime "0" 
     .SetColorByValue "True" 
     .DrawStepLines "False" 
     .DrawIsoLongitudeLatitudeLines "False" 
     .ShowStructure "True" 
     .SetStructureTransparent "False" 
     .SetFarfieldTransparent "False" 
     .SetSpecials "enablepolarextralines" 
     .SetPlotMode "Directivity" 
     .Distance "1" 
     .UseFarfieldApproximation "True" 
     .SetScaleLinear "False" 
     .SetLogRange "30" 
     .SetLogNorm "0" 
     .DBUnit "0" 
     .EnableFixPlotMaximum "False" 
     .SetFixPlotMaximumValue "1" 
     .SetInverseAxialRatio "False" 
     .SetAxesType "user" 
     .SetAntennaType "unknown" 
     .Phistart "1.000000e+000", "0.000000e+000", "0.000000e+000" 
     .Thetastart "0.000000e+000", "0.000000e+000", "1.000000e+000" 
     .PolarizationVector "0.000000e+000", "1.000000e+000", "0.000000e+000" 
     .SetCoordinateSystemType "spherical" 
     .SetAutomaticCoordinateSystem "True" 
     .SetPolarizationType "Linear" 
     .SlantAngle 0.000000e+000 
     .Origin "bbox" 
     .Userorigin "0.000000e+000", "0.000000e+000", "0.000000e+000" 
     .SetUserDecouplingPlane "False" 
     .UseDecouplingPlane "False" 
     .DecouplingPlaneAxis "X" 
     .DecouplingPlanePosition "0.000000e+000" 
     .LossyGround "False" 
     .GroundEpsilon "1" 
     .GroundKappa "0" 
     .EnablePhaseCenterCalculation "False" 
     .SetPhaseCenterAngularLimit "3.000000e+001" 
     .SetPhaseCenterComponent "boresight" 
     .SetPhaseCenterPlane "both" 
     .ShowPhaseCenter "True" 
     .StoreSettings
End With

'@ switch working plane

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Plot.DrawWorkplane "true"

'@ define time domain solver parameters

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
Mesh.SetCreator "High Frequency" 
With Solver 
     .Method "Hexahedral"
     .CalculationType "TD-S"
     .StimulationPort "All"
     .StimulationMode "All"
     .SteadyStateLimit "-30.0"
     .MeshAdaption "False"
     .AutoNormImpedance "False"
     .NormingImpedance "50"
     .CalculateModesOnly "False"
     .SParaSymmetry "False"
     .StoreTDResultsInCache  "False"
     .FullDeembedding "False"
     .SuperimposePLWExcitation "False"
     .UseSensitivityAnalysis "False"
End With

'@ set mesh properties (Hexahedral)

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With Mesh 
     .MeshType "PBA" 
     .SetCreator "High Frequency"
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "Version", 1%
     'MAX CELL - WAVELENGTH REFINEMENT 
     .Set "StepsPerWaveNear", "10" 
     .Set "StepsPerWaveFar", "10" 
     .Set "WavelengthRefinementSameAsNear", "1" 
     'MAX CELL - GEOMETRY REFINEMENT 
     .Set "StepsPerBoxNear", "5" 
     .Set "StepsPerBoxFar", "1" 
     .Set "MaxStepNear", "0" 
     .Set "MaxStepFar", "0" 
     .Set "ModelBoxDescrNear", "maxedge" 
     .Set "ModelBoxDescrFar", "maxedge" 
     .Set "UseMaxStepAbsolute", "0" 
     .Set "GeometryRefinementSameAsNear", "0" 
     'MIN CELL 
     .Set "UseRatioLimitGeometry", "1" 
     .Set "RatioLimitGeometry", "20" 
     .Set "MinStepGeometryX", "0" 
     .Set "MinStepGeometryY", "0" 
     .Set "MinStepGeometryZ", "0" 
     .Set "UseSameMinStepGeometryXYZ", "1" 
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "FaceRefinementOn", "0" 
     .Set "FaceRefinementPolicy", "2" 
     .Set "FaceRefinementRatio", "2" 
     .Set "FaceRefinementStep", "0" 
     .Set "FaceRefinementNSteps", "2" 
     .Set "EllipseRefinementOn", "0" 
     .Set "EllipseRefinementPolicy", "2" 
     .Set "EllipseRefinementRatio", "2" 
     .Set "EllipseRefinementStep", "0" 
     .Set "EllipseRefinementNSteps", "2" 
     .Set "FaceRefinementBufferLines", "3" 
     .Set "EdgeRefinementOn", "1" 
     .Set "EdgeRefinementPolicy", "1" 
     .Set "EdgeRefinementRatio", "2" 
     .Set "EdgeRefinementStep", "0" 
     .Set "EdgeRefinementBufferLines", "3" 
     .Set "RefineEdgeMaterialGlobal", "0" 
     .Set "RefineAxialEdgeGlobal", "0" 
     .Set "BufferLinesNear", "3" 
     .Set "UseDielectrics", "1" 
     .Set "EquilibrateOn", "0" 
     .Set "Equilibrate", "1.5" 
     .Set "IgnoreThinPanelMaterial", "0" 
End With 
With MeshSettings 
     .SetMeshType "Hex" 
     .Set "SnapToAxialEdges", "1"
     .Set "SnapToPlanes", "1"
     .Set "SnapToSpheres", "1"
     .Set "SnapToEllipses", "1"
     .Set "SnapToCylinders", "1"
     .Set "SnapToCylinderCenters", "1"
     .Set "SnapToEllipseCenters", "1"
End With 
With Discretizer 
     .MeshType "PBA" 
     .PBAType "Fast PBA" 
     .AutomaticPBAType "True" 
     .FPBAAccuracyEnhancement "enable"
     .ConnectivityCheck "False"
     .ConvertGeometryDataAfterMeshing "True" 
     .UsePecEdgeModel "True" 
     .GapDetection "False" 
     .FPBAGapTolerance "1e-3" 
     .SetMaxParallelMesherThreads "Hex", "12"
     .SetParallelMesherMode "Hex", "Maximum"
     .PointAccEnhancement "0" 
     .UseSplitComponents "True" 
     .EnableSubgridding "False" 
     .PBAFillLimit "99" 
     .AlwaysExcludePec "False" 
End With

'@ farfield plot options

'[VERSION]2014.3|23.0.0|20140703[/VERSION]
With FarfieldPlot 
     .Plottype "3D" 
     .Vary "angle1" 
     .Theta "0" 
     .Phi "0" 
     .Step "5" 
     .Step2 "5" 
     .SetLockSteps "True" 
     .SetPlotRangeOnly "False" 
     .SetThetaStart "0" 
     .SetThetaEnd "180" 
     .SetPhiStart "0" 
     .SetPhiEnd "360" 
     .SetTheta360 "False" 
     .SymmetricRange "False" 
     .SetTimeDomainFF "False" 
     .SetFrequency "2.442" 
     .SetTime "0" 
     .SetColorByValue "True" 
     .DrawStepLines "False" 
     .DrawIsoLongitudeLatitudeLines "False" 
     .ShowStructure "True" 
     .SetStructureTransparent "False" 
     .SetFarfieldTransparent "False" 
     .SetSpecials "enablepolarextralines" 
     .SetPlotMode "Directivity" 
     .Distance "1" 
     .UseFarfieldApproximation "True" 
     .SetScaleLinear "False" 
     .SetLogRange "28" 
     .SetLogNorm "0" 
     .DBUnit "0" 
     .EnableFixPlotMaximum "False" 
     .SetFixPlotMaximumValue "1" 
     .SetInverseAxialRatio "False" 
     .SetAxesType "user" 
     .SetAntennaType "unknown" 
     .Phistart "1.000000e+000", "0.000000e+000", "0.000000e+000" 
     .Thetastart "0.000000e+000", "0.000000e+000", "1.000000e+000" 
     .PolarizationVector "0.000000e+000", "1.000000e+000", "0.000000e+000" 
     .SetCoordinateSystemType "spherical" 
     .SetAutomaticCoordinateSystem "True" 
     .SetPolarizationType "Linear" 
     .SlantAngle 0.000000e+000 
     .Origin "bbox" 
     .Userorigin "0.000000e+000", "0.000000e+000", "0.000000e+000" 
     .SetUserDecouplingPlane "False" 
     .UseDecouplingPlane "False" 
     .DecouplingPlaneAxis "X" 
     .DecouplingPlanePosition "0.000000e+000" 
     .LossyGround "False" 
     .GroundEpsilon "1" 
     .GroundKappa "0" 
     .EnablePhaseCenterCalculation "False" 
     .SetPhaseCenterAngularLimit "3.000000e+001" 
     .SetPhaseCenterComponent "boresight" 
     .SetPhaseCenterPlane "both" 
     .ShowPhaseCenter "True" 
     .StoreSettings
End With 

